----------------
title : C++ 레퍼런스 - string 라이브러리
cat_title :  <string>
ref_title : <string>
path : /C++ Reference/string
publish_date : 2020-07-17
----------------

##@ cpp-ref-start

#@ string

C++ 문자열 라이브러리는 기본적으로 3 가지 종류의 문자열 타입들을 지원하고 있습니다.

* `std::basic_string` - 임의의 문자(`char`, `wchar_t`) 열들을 보관하는 템플릿 클래스
* `std::basic_string_view` (C++ 17) - 문자열을 실제로 소유하지는 않고 '읽기' 만 수행할 수 있는 클래스로 `std::basic_string` 보다 훨씬 가벼움
* 널 종류 문자열 - 널 문자로 끝나는 배열

### std::basic_string

템플릿 클래스 `std::basic_string` 은 임의의 문자의 나열을 저장하고, 또 수정하는 작업을 수행할 수 있습니다. 이 클래스에서 제공되는 함수를 통해, 문자열의 생성, 수정, 그리고 소멸 까지 간편하게 수행할 수 있습니다.

자주 수행하는 문자 타입들에 대해 템플릿 특수화 버전들이 기본적으로 제공됩니다.

|타입|정의|
|----|----|
|`std::string`|`std::basic_string<char>`|
|`std::wstring`|`std::basic_string<wchar_t>`|
|`std::u16string`|`std::basic_string<char16_t>`|
|`std::u32string`|`std::basic_string<char32_t>`|


### std::basic_string_view

`std::basic_string_view` 는 C++17 에 추가되었으며, 문자열 객체에 **읽기 전용** 접근을 수행할 수 있습니다. `std::basic_string` 과는 다르게 문자열을 실제 소유하고 있지는 않기 때문에 매우 가볍습니다. 따라서, 문자열을 수정하지 않고, 읽기만 하는 경우에 유용하게 사용할 수 있습니다.

`std::basic_string` 과 사용법이 매우 유사하고, 자주 사용하는 문자열 타입들에 대해 템플릿 특수화 버전들을 기본적으로 제공합니다.

|타입|정의|
|----|----|
|`std::string_view`|`std::basic_string_view<char>`|
|`std::wstring_view`|`std::basic_string_view<wchar_t>`|
|`std::u16string_view`|`std::basic_string_view<char16_t>`|
|`std::u32string_view`|`std::basic_string_view<char32_t>`|


### 널 종류 문자열

널 종료 문자열은, 특수 문자인 _Null_ 로 끝나는 문자를 의미합니다. 이 라이브러리를 통해, 널 종료 문자열을 처리할 수 있습니다. 이 부분은 C 에서의 `string` 라이브러리와 유사합니다.

### std::char_traits

클래스 템플릿 `std::char_traits` 은 `std::basic_string` 과 `std::basic_string_view` 를 위한 여러 함수들과 타입들을 제공하고 있습니다.

또한 아래와 같은 특수화 된 클래스도 제공합니다.

```cpp-formatted
template <>
class char_traits<char>;
template <>
class char_traits<wchar_t>;
template <>
class char_traits<char16_t>;
template <>
class char_traits<char32_t>;
```